/***********************************************************************
*
* This file:    ss-ajps.do
* Authors:      Ken Scheve and Matt Slaughter
* Date:         April 2005
* Description:  Replication of Tables 1-3 in "Economic Insecurity and the Globalization
*               of Production" AJPS Vol. 48 No. 4 October 2004 pp. 662-674.
*
************************************************************************/
#delimit ;
set mem 200m;
set mat 200;
set logtype text;
log using ss-ajps04.log, replace;
clear;
use ss-ajps04.dta;

/** TABLE 1 DESCRIPTIVE STATISTICS **/

sum jsecsat2 fdisector2tn fdishri0 fdishrt0 union3 man1 unempsec ed1 age2 hhinc1 if year==1991 & fulltim==1 &  wrkfrc==1 & selfemp==0 & private==1 & jsecsat2~=. & ed1~=.  & fdisector2tn~=. & age2~=. & hhinc1~=. & union3~=. & man1~=. & unempsec~=. & fdishri0~=. & fdishrt0~=.;
sum jsecsat2 fdisector2tn fdishri0 fdishrt0 union3 man1 unempsec ed1 age2 hhinc1 if year==1992 & fulltim==1 &  wrkfrc==1 & selfemp==0 & private==1 & jsecsat2~=. & ed1~=.  & fdisector2tn~=. & age2~=. & hhinc1~=. & union3~=. & man1~=. & unempsec~=. & fdishri0~=. & fdishrt0~=.;
sum jsecsat2 fdisector2tn fdishri0 fdishrt0 union3 man1 unempsec ed1 age2 hhinc1 if year==1993 & fulltim==1 &  wrkfrc==1 & selfemp==0 & private==1 & jsecsat2~=. & ed1~=.  & fdisector2tn~=. & age2~=. & hhinc1~=. & union3~=. & man1~=. & unempsec~=. & fdishri0~=. & fdishrt0~=.;
sum jsecsat2 fdisector2tn fdishri0 fdishrt0 union3 man1 unempsec ed1 age2 hhinc1 if year==1994 & fulltim==1 &  wrkfrc==1 & selfemp==0 & private==1 & jsecsat2~=. & ed1~=.  & fdisector2tn~=. & age2~=. & hhinc1~=. & union3~=. & man1~=. & unempsec~=. & fdishri0~=. & fdishrt0~=.;
sum jsecsat2 fdisector2tn fdishri0 fdishrt0 union3 man1 unempsec ed1 age2 hhinc1 if year==1995 & fulltim==1 &  wrkfrc==1 & selfemp==0 & private==1 & jsecsat2~=. & ed1~=.  & fdisector2tn~=. & age2~=. & hhinc1~=. & union3~=. & man1~=. & unempsec~=. & fdishri0~=. & fdishrt0~=.;
sum jsecsat2 fdisector2tn fdishri0 fdishrt0 union3 man1 unempsec ed1 age2 hhinc1 if year==1996 & fulltim==1 &  wrkfrc==1 & selfemp==0 & private==1 & jsecsat2~=. & ed1~=.  & fdisector2tn~=. & age2~=. & hhinc1~=. & union3~=. & man1~=. & unempsec~=. & fdishri0~=. & fdishrt0~=.;
sum jsecsat2 fdisector2tn fdishri0 fdishrt0 union3 man1 unempsec ed1 age2 hhinc1 if year==1997 & fulltim==1 &  wrkfrc==1 & selfemp==0 & private==1 & jsecsat2~=. & ed1~=.  & fdisector2tn~=. & age2~=. & hhinc1~=. & union3~=. & man1~=. & unempsec~=. & fdishri0~=. & fdishrt0~=.;
sum jsecsat2 fdisector2tn fdishri0 fdishrt0 union3 man1 unempsec ed1 age2 hhinc1 if year==1998 & fulltim==1 &  wrkfrc==1 & selfemp==0 & private==1 & jsecsat2~=. & ed1~=.  & fdisector2tn~=. & age2~=. & hhinc1~=. & union3~=. & man1~=. & unempsec~=. & fdishri0~=. & fdishrt0~=.;
sum jsecsat2 fdisector2tn fdishri0 fdishrt0 union3 man1 unempsec ed1 age2 hhinc1 if year==1999 & fulltim==1 &  wrkfrc==1 & selfemp==0 & private==1 & jsecsat2~=. & ed1~=.  & fdisector2tn~=. & age2~=. & hhinc1~=. & union3~=. & man1~=. & unempsec~=. & fdishri0~=. & fdishrt0~=.;

/** TABLE 2 Panel Analysis of Economic Insecurity, 1991-1999 **/
tsset pid yearv2, yearly;

/**** Model Random Effects ***/

xtreg jsecsat2 fdisector2tn y1992 y1993 y1994 y1995 y1996 y1997 y1998 y1999 if (fulltim==1 &  wrkfrc==1 & selfemp==0 & private==1), re i(pid);
xttest0;
xthausman;

/**** Model Fixed Effects ***/

xtreg jsecsat2 fdisector2tn y1992 y1993 y1994 y1995 y1996 y1997 y1998 y1999 if (fulltim==1 &  wrkfrc==1 & selfemp==0 & private==1), fe i(pid);

/**** Model Fixed Effects with demographic controls and sector controls ***/

xtreg jsecsat2 fdisector2tn ed1 age2 hhinc1 union3 unempsec man1 y1992 y1993 y1994 y1995 y1996 y1997 y1998 y1999 if (fulltim==1 &  wrkfrc==1 & selfemp==0 & private==1), fe i(pid);

/** TABLE 3 Panel Analysis of Economic Insecurity, 1991-1999: Alternative Measures of FDI Exposure (Report coefficient on key FDI variables only)**/

/**** Model Fixed Effects ***/

xtreg jsecsat2 fdishrt0 y1992 y1993 y1994 y1995 y1996 y1997 y1998 y1999 if (fulltim==1 &  wrkfrc==1 & selfemp==0 & private==1), fe i(pid);
xtreg jsecsat2 fdishri0 y1992 y1993 y1994 y1995 y1996 y1997 y1998 y1999 if (fulltim==1 &  wrkfrc==1 & selfemp==0 & private==1), fe i(pid);

/**** Model Fixed Effects with demographic controls and sector controls ***/

xtreg jsecsat2 fdishrt0 ed1 age2 hhinc1 union3 unempsec man1 y1992 y1993 y1994 y1995 y1996 y1997 y1998 y1999 if (fulltim==1 &  wrkfrc==1 & selfemp==0 & private==1), fe i(pid);
xtreg jsecsat2 fdishri0 ed1 age2 hhinc1 union3 unempsec man1 y1992 y1993 y1994 y1995 y1996 y1997 y1998 y1999 if (fulltim==1 &  wrkfrc==1 & selfemp==0 & private==1), fe i(pid);


log close;

