/****************************************************************************
*
* This file:    SSrelrep.do
* Author:       Ken Scheve and David Stasavage
* Date:         April 2006
* Description:  Replicates all analyses in Religion and Preferences for Social Insurance
*		including those reported in the on-line appendix.
*****************************************************************************/
#delimit ;
clear;
set mem 200m;
set matsize 100;
log using SSrelrep.log, replace;

/****************************************
*
* Replication of Table 1
*
*****************************************/
use wvalaggSSrep.dta;

reg ssw gini_8090 trade prop65 maj cath buddh godimp if oecd==1, robust;
reg ssw gini_8090 trade prop65 maj cath buddh relpractice if oecd==1, robust;

ivreg2 ssw gini_8090 trade prop65 maj cath buddh (godimp=relfrac Nstatsuprel90 staterelig) if oecd==1, robust first;
ivreg2 ssw gini_8090 trade prop65 maj cath buddh (relpractice=relfrac Nstatsuprel90 staterelig) if oecd==1, robust first;

/****************************************
*
* Replication of Table A
*
*****************************************/

reg ssw gini_8090 trade prop65 maj rgdph cath buddh godimp, robust;
reg ssw gini_8090 trade prop65 maj rgdph cath buddh relpractice, robust;

ivreg2 ssw gini_8090 trade prop65 maj rgdph cath buddh (godimp=relfrac Nstatsuprel90 staterelig), robust first;
ivreg2 ssw gini_8090 trade prop65 maj rgdph cath buddh (relpractice=relfrac Nstatsuprel90 staterelig), robust first;

/****************************************
*
* Replication of Table B
*
*****************************************/

reg ssw gini_8090 trade prop65 maj cath buddh godimp if oecd==1 & cntrycd~=111, robust;
reg ssw gini_8090 trade prop65 maj cath buddh relpractice if oecd==1 & cntrycd~=111, robust;

ivreg2 ssw gini_8090 trade prop65 maj cath buddh (godimp=relfrac Nstatsuprel90 staterelig) if oecd==1 & cntrycd~=111, robust first;
ivreg2 ssw gini_8090 trade prop65 maj cath buddh (relpractice=relfrac Nstatsuprel90 staterelig) if oecd==1 & cntrycd~=111, robust first;

/****************************************
*
* Replication of Table C
*
*****************************************/

reg ssw gini_8090 trade prop65 maj cath buddh rgdph godimp if oecd==1, robust;
reg ssw gini_8090 trade prop65 maj cath buddh rgdph relpractice if oecd==1, robust;

ivreg2 ssw gini_8090 trade prop65 maj cath buddh rgdph (godimp=relfrac Nstatsuprel90 staterelig) if oecd==1, robust first;
ivreg2 ssw gini_8090 trade prop65 maj cath buddh rgdph (relpractice=relfrac Nstatsuprel90 staterelig) if oecd==1, robust first;

/****************************************
*
* Replication of Table D
*
*****************************************/

reg ssw gini_8090 trade prop65 maj cath buddh avelf godimp if oecd==1, robust;
reg ssw gini_8090 trade prop65 maj cath buddh avelf relpractice if oecd==1, robust;

ivreg2 ssw gini_8090 trade prop65 maj cath buddh avelf (godimp=relfrac Nstatsuprel90 staterelig) if oecd==1, robust first;
ivreg2 ssw gini_8090 trade prop65 maj cath buddh avelf (relpractice=relfrac Nstatsuprel90 staterelig) if oecd==1, robust first;

/****************************************
*
* Replication of Table E
*
*****************************************/

reg ssw gini_8090 trade prop65 maj cath buddh coordination godimp if oecd==1, robust;
reg ssw gini_8090 trade prop65 maj cath buddh coordination relpractice if oecd==1, robust;

ivreg2 ssw gini_8090 trade prop65 maj cath buddh coordination (godimp=relfrac Nstatsuprel90 staterelig) if oecd==1, robust first;
ivreg2 ssw gini_8090 trade prop65 maj cath buddh coordination (relpractice=relfrac Nstatsuprel90 staterelig) if oecd==1, robust first;

/****************************************
*
* Replication of Table F
*
*****************************************/

reg ssw gini_8090 trade prop65 maj cath buddh union godimp if oecd==1, robust;
reg ssw gini_8090 trade prop65 maj cath buddh union relpractice if oecd==1, robust;

ivreg2 ssw gini_8090 trade prop65 maj cath buddh union (godimp=relfrac Nstatsuprel90 staterelig) if oecd==1, robust first;
ivreg2 ssw gini_8090 trade prop65 maj cath buddh union (relpractice=relfrac Nstatsuprel90 staterelig) if oecd==1, robust first;

/****************************************
*
* Replication of Table G
*
*****************************************/

reg ssw gini_8090 trade prop65 maj cath buddh Chdem godimp if oecd==1, robust;
reg ssw gini_8090 trade prop65 maj cath buddh Chdem relpractice if oecd==1, robust;

ivreg2 ssw gini_8090 trade prop65 maj cath buddh Chdem (godimp=relfrac Nstatsuprel90 staterelig) if oecd==1, robust first;
ivreg2 ssw gini_8090 trade prop65 maj cath buddh Chdem (relpractice=relfrac Nstatsuprel90 staterelig) if oecd==1, robust first;

/****************************************
*
* Replication of Table H
*
*****************************************/

reg ssw gini_8090 trade prop65 maj cath buddh cog9095 godimp if oecd==1, robust;
reg ssw gini_8090 trade prop65 maj cath buddh cog9095 relpractice if oecd==1, robust;

ivreg2 ssw gini_8090 trade prop65 maj cath buddh cog9095 (godimp=relfrac Nstatsuprel90 staterelig) if oecd==1, robust first;
ivreg2 ssw gini_8090 trade prop65 maj cath buddh cog9095 (relpractice=relfrac Nstatsuprel90 staterelig) if oecd==1, robust first;

clear;

/****************************************
*
* Replication of Table I
*
*****************************************/
use wval3aggSSrep.dta;

reg ssw gini_8090 trade prop65 maj cath buddh godimp, robust;
reg ssw gini_8090 trade prop65 maj cath buddh godimp succsluck, robust;

reg ssw gini_8090 trade prop65 maj cath buddh relpractice, robust;
reg ssw gini_8090 trade prop65 maj cath buddh relpractice succsluck, robust;

clear;

/****************************************
*
* Replication of Table 2
*
*****************************************/
use isspindSSrep.dta;

regress spend3 respattnd female educyrs2 age famquart unemployed union cath protes coecdA2-coecdA13 [pweight=weightfctr] if hiincoecd2==1, cluster(cntryna2);
regress spend3 respattnd female educyrs2 age famquart unemployed union partylr cath protes coecdA2-coecdA13 [pweight=weightfctr] if hiincoecd2==1, cluster(cntryna2);

/****************************************
*
* Replication of Table 3
*
*****************************************/

sort cntryna2;
by cntryna2: regress spend3 respattnd female educyrs2 age famquart unemployed union cath protes [pweight=weightfctr] if hiincoecd2==1, robust;
by cntryna2: regress spend3 respattnd female educyrs2 age famquart unemployed union cath protes partylr [pweight=weightfctr] if hiincoecd2==1, robust;

/****************************************
*
* Replication of Table 4
*
*****************************************/

regress govspenv respattnd female educyrs2 age famquart unemployed union cath protes coecdA2-coecdA13 [pweight=weightfctr] if hiincoecd2==1, cluster(cntryna2);
regress govsplawenf respattnd female educyrs2 age famquart unemployed union cath protes coecdA2-coecdA13 [pweight=weightfctr] if hiincoecd2==1, cluster(cntryna2);
regress govsped respattnd female educyrs2 age famquart unemployed union cath protes coecdA2-coecdA13 [pweight=weightfctr] if hiincoecd2==1, cluster(cntryna2);
regress govspdef respattnd female educyrs2 age famquart unemployed union cath protes coecdA2-coecdA13 [pweight=weightfctr] if hiincoecd2==1, cluster(cntryna2);
regress govspcultarts respattnd female educyrs2 age famquart unemployed union cath protes coecdA2-coecdA13 [pweight=weightfctr] if hiincoecd2==1, cluster(cntryna2);

/****************************************
*
* Replication of Table J
*
*****************************************/

regress spend3 respattnd female educyrs2 age famquart unemployed union cath protes cA2-cA23 [pweight=weightfctr], cluster(cntryna2);
regress spend3 respattnd female educyrs2 age famquart unemployed union partylr cath protes cA2-cA23 [pweight=weightfctr], cluster(cntryna2);

/****************************************
*
* Replication of Table K
*
*****************************************/

global peneq "(govsppension respattnd female educyrs2 age famquart unemployed union cath protes coecdA3-coecdA10 coecdA12 coecdA13)"; 
global hltheq "(govsphealth respattnd female educyrs2 age famquart unemployed union cath protes coecdA3-coecdA10 coecdA12 coecdA13)";
global unemeq "(govspunempben respattnd female educyrs2 age famquart unemployed union cath protes coecdA3-coecdA10 coecdA12 coecdA13)";

constraint define 1 [govsppension]respattnd=[govsphealth]respattnd;
constraint define 2 [govsppension]respattnd=[govspunempben]respattnd;

sureg $peneq $hltheq $unemeq if hiincoecd2==1, constr(1 2) corr ;

/****************************************
*
* Replication of Table L
*
*****************************************/

regress spend3 respattnd female educyrs2 age famquart unemployed union adulthous cath protes coecdA2-coecdA13 [pweight=weightfctr] if hiincoecd2==1, cluster(cntryna2);
regress spend3 respattnd female educyrs2 age famquart unemployed union housesize2 cath protes coecdA2-coecdA13 [pweight=weightfctr] if hiincoecd2==1, cluster(cntryna2);
regress spend3 respattnd female educyrs2 age famquart unemployed union adulthous housesize2 cath protes coecdA2-coecdA13 [pweight=weightfctr] if hiincoecd2==1, cluster(cntryna2);

/****************************************
*
* Replication of Table M
*
*****************************************/

regress spend3 respattnd female educyrs2 age famquart unemployed rural union cath protes coecdA2-coecdA13 [pweight=weightfctr] if hiincoecd2==1, cluster(cntryna2);
regress spend3 respattnd female educyrs2 age famquart unemployed rural union partylr cath protes coecdA2-coecdA13 [pweight=weightfctr] if hiincoecd2==1, cluster(cntryna2);

regress spend3 respattnd female educyrs2 age famquart unemployed rural attxrural union cath protes coecdA2-coecdA13 [pweight=weightfctr] if hiincoecd2==1, cluster(cntryna2);
regress spend3 respattnd female educyrs2 age famquart unemployed rural attxrural union partylr cath protes coecdA2-coecdA13 [pweight=weightfctr] if hiincoecd2==1, cluster(cntryna2);

/****************************************
*
* Replication of Table N
*
*****************************************/

regress spend3 respattnd s_comp female educyrs2 age famquart unemployed union cath protes coecdA2-coecdA13 [pweight=weightfctr] if hiincoecd2==1, cluster(cntryna2);
regress spend3 respattnd s_comp female educyrs2 age famquart unemployed union partylr cath protes coecdA2-coecdA13 [pweight=weightfctr] if hiincoecd2==1, cluster(cntryna2);


/****************************************
*
* Replication of Table O
*
*****************************************/

regress spend3 respattnd attndcath attndprotes female educyrs2 age famquart unemployed union cath protes coecdA2-coecdA13 [pweight=weightfctr] if hiincoecd2==1, cluster(cntryna2);
regress spend3 respattnd attndcath attndprotes female educyrs2 age famquart unemployed union partylr cath protes coecdA2-coecdA13 [pweight=weightfctr] if hiincoecd2==1, cluster(cntryna2);

clear;

/****************************************
*
* Replication of Table P
*
*****************************************/
use wvalindSSrep.dta;

reg ideol2 godimp succsluck female age educ2 income unemployed unionme cath protes coecd2-coecd20 if hiincoecd==1, cluster(cntrycde);
reg ideol2 relpractice succsluck female age educ2 income unemployed unionme cath protes coecd2-coecd20 if hiincoecd==1, cluster(cntrycde);

clear;
log close;

