/****************************************************************************
*
* This file:    SSreplication.do
* Author:       Ken Scheve and David Stasavage
* Date:         October 2008
* Description:	This file replicates the main analyses in "Institutions, 
*		Partisanship, and Inequality in the Long Run" published in 
*    		World Politics.
*
*****************************************************************************/
#delimit ;
clear;
set mem 200m;
set matsize 100;
log using SSreplication.log, replace;


/*********************
* Table 1
**********************/

use "OECD 1996 wage data.dta", clear;

xi: reg top10_top1 i.state;
predict etop10_top1 if e(sample), res;
xi: reg _90_10 i.state;
predict e90_10 if e(sample), res;
xi: reg _90_50 i.state;
predict e90_50 if e(sample), res;
xi: reg _50_10 i.state if e(sample);
predict e50_10 if e(sample) , res;

pwcorr top10_top1 _90_10 _90_50 _50_10, obs;

pwcorr etop10_top1 e90_10 e90_50 e50_10, obs;


use "lydall replication.dta", clear;

xi: reg top10_top1 i.state;
predict etop10_top1 if e(sample), res;
xi: reg _90_15 i.state;
predict e90_15 if e(sample), res;
xi: reg _90_50 i.state;
predict e90_50 if e(sample), res;
xi: reg _50_15 i.state if e(sample);
predict e50_15 if e(sample) , res;

pwcorr top10_top1 _90_15 _90_50 _50_15, obs;

pwcorr etop10_top1 e90_15 e90_50 e50_15, obs;

clear;

/*********************
* Table 2
**********************/

miest iqimpr xtpcse top10la_top1la top10_top1laL1 mgdppc tradedep secsharel10  wdeccentld wcentld totden leftgov nondem funisuf  fempart p3-p18, nsets(10);
miest iqimpr xtpcse top10la_top1la top10_top1laL1 mgdppc tradedep secsharel10  wdeccentld wcentld totden leftgov nondem funisuf  fempart c2-c13 p3-p18, nsets(10);

miest iqimpr xtpcse top10la top10laL1 mgdppc tradedep secsharel10  wdeccentld wcentld totden leftgov nondem funisuf  fempart p3-p18, nsets(10);
miest iqimpr xtpcse top10la top10laL1 mgdppc tradedep secsharel10  wdeccentld wcentld totden leftgov nondem funisuf  fempart c2-c13 p3-p18, nsets(10);

miest iqimpr xtpcse top1la top1laL1 mgdppc tradedep secsharel10  wdeccentld wcentld totden leftgov nondem funisuf  fempart p3-p18, nsets(10);
miest iqimpr xtpcse top1la top1laL1 mgdppc tradedep secsharel10  wdeccentld wcentld totden leftgov nondem funisuf  fempart c2-c13 p3-p18, nsets(10);


/*********************
* Table 3
**********************/

miest iqimpr xtpcse top10la_top1la top10_top1laL1 mgdppc tradedep secsharel10  wdeccentld wcentld totden leftgov nondem funisuf  fempart p15-p18 if period>15, nsets(10);
miest iqimpr xtpcse top10la_top1la top10_top1laL1 mgdppc tradedep secsharel10  wdeccentld wcentld totden leftgov nondem funisuf  fempart c2-c13 p15-p18 if period>15, nsets(10);

miest iqimpr xtpcse top10la top10laL1 mgdppc tradedep secsharel10  wdeccentld wcentld totden leftgov nondem funisuf  fempart p15-p18 if period>15, nsets(10);
miest iqimpr xtpcse top10la top10laL1 mgdppc tradedep secsharel10  wdeccentld wcentld totden leftgov nondem funisuf  fempart c2-c13 p15-p18 if period>15, nsets(10);

miest iqimpr xtpcse top1la top1laL1 mgdppc tradedep secsharel10  wdeccentld wcentld totden leftgov nondem funisuf  fempart p15-p18 if period>15, nsets(10);
miest iqimpr xtpcse top1la top1laL1 mgdppc tradedep secsharel10  wdeccentld wcentld totden leftgov nondem funisuf  fempart c2-c13 p15-p18 if period>15, nsets(10);

/*********************
* Table 4
**********************/

miest iqimpr xtpcse top10la_top1la top10_top1laL1 mgdppc tradedep secsharel10  wdeccentld wcentld totden leftgov nondem funisuf  fempart p3-p13 if period<=15, nsets(10);
miest iqimpr xtpcse top10la_top1la top10_top1laL1 mgdppc tradedep secsharel10  wdeccentld wcentld totden leftgov nondem funisuf  fempart c2-c13 p3-p13 if period<=15, nsets(10);

miest iqimpr xtpcse top10la top10laL1 mgdppc tradedep secsharel10  wdeccentld wcentld totden leftgov nondem funisuf  fempart p3-p13 if period<=15, nsets(10);
miest iqimpr xtpcse top10la top10laL1 mgdppc tradedep secsharel10  wdeccentld wcentld totden leftgov nondem funisuf  fempart c2-c13 p3-p13 if period<=15, nsets(10);

miest iqimpr xtpcse top1la top1laL1 mgdppc tradedep secsharel10  wdeccentld wcentld totden leftgov nondem funisuf  fempart p3-p13 if period<=15, nsets(10);
miest iqimpr xtpcse top1la top1laL1 mgdppc tradedep secsharel10  wdeccentld wcentld totden leftgov nondem funisuf  fempart c2-c13 p3-p13 if period<=15, nsets(10);

/*********************
* Table 5
**********************/

use "ineqlwdrep.dta", clear;

tsset stnum year;
sort stnum year;

/* Linearly interpolate missing L1.top1i values */  

qby stnum: ipolate top1la year, gen(top1i);
qby stnum: ipolate top10la year, gen(top10i);
gen top10_1x=100*((top10i-top1i)/(100-top1i));

/*  Sweden Top Incomes*/ 

gen trend1=year-1900;
gen trend2=year-1900;
replace trend1=0 if year>1937;
replace trend2=0 if year<1938;

newey top10_1x trend1 trend2 if state=="SWE" , lag(5); 

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1943;
replace trend1=0 if year>1942;

newey top10_1x trend1 trend2 if state=="SWE" , lag(5); 

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1948;
replace trend1=0 if year>1947;

newey top10_1x trend1 trend2 if state=="SWE" , lag(5);  

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1953;
replace trend1=0 if year>1952; 

newey top10_1x trend1 trend2 if state=="SWE" , lag(5); 

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1958;
replace trend1=0 if year>1957;

newey top10_1x trend1 trend2 if state=="SWE" , lag(5); 

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1963;
replace trend1=0 if year>1962;

newey top10_1x trend1 trend2 if state=="SWE" , lag(5); 

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1968;
replace trend1=0 if year>1967;

newey top10_1x trend1 trend2 if state=="SWE" , lag(5); 

/* Netherlands Top Incomes */ 

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1931;
replace trend1=0 if year>1930;

newey top10_1x trend1 trend2 if state=="NED" , lag(5); 

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1936;
replace trend1=0 if year>1935;

newey top10_1x trend1 trend2 if state=="NED" , lag(5); 

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1941;
replace trend1=0 if year>1940;

newey top10_1x trend1 trend2 if state=="NED" , lag(5); 

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1946;
replace trend1=0 if year>1945;

newey top10_1x trend1 trend2 if state=="NED" , lag(5);

test trend1=trend2; 
replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1951;
replace trend1=0 if year>1950;

newey top10_1x trend1 trend2 if state=="NED" , lag(5); 

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1956;
replace trend1=0 if year>1955;

newey top10_1x trend1 trend2 if state=="NED" , lag(5); 

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1961;
replace trend1=0 if year>1960;

newey top10_1x trend1 trend2 if state=="NED" , lag(5); 

/* Sweden Wages */

use "ljungbergseriesrep.dta", clear;

tsset year;

gen trend1=year-1900;
gen trend2=year-1900;
replace trend1=0 if year>1937;
replace trend2=0 if year<1938;

newey multiple trend1 trend2  , lag(5);  

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1943;
replace trend1=0 if year>1942;

newey multiple trend1 trend2  , lag(5);  

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1948;
replace trend1=0 if year>1947;

newey multiple trend1 trend2 , lag(5);  

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1953;
replace trend1=0 if year>1952;

newey multiple trend1 trend2  , lag(5);  

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1958;
replace trend1=0 if year>1957;

newey multiple trend1 trend2  , lag(5);  

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1963;
replace trend1=0 if year>1962;

newey multiple trend1 trend2  , lag(5);

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1968;
replace trend1=0 if year>1967;

newey multiple trend1 trend2 , lag(5);  

/* Denmark Series */ 

use "denmarkintegerseriesrep.dta", clear;

tsset year;

gen trend1=year-1900;
gen trend2=year-1900;
replace trend1=0 if year>1918;
replace trend2=0 if year<1919;

newey mec trend1 trend2, lag(5); 
newey wage trend1 trend2, lag(5) force;

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1924;
replace trend1=0 if year>1923;

newey mec trend1 trend2, lag(5); 
newey wage trend1 trend2, lag(5) force;

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1929;
replace trend1=0 if year>1928;

newey mec trend1 trend2, lag(5); 
newey wage trend1 trend2, lag(5) force;

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1934;
replace trend1=0 if year>1933;

newey mec trend1 trend2, lag(5); 
newey wage trend1 trend2, lag(5) force;

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1939;
replace trend1=0 if year>1938;

newey mec trend1 trend2, lag(5); 
newey wage trend1 trend2, lag(5)   force;

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1944;
replace trend1=0 if year>1943;

newey mec trend1 trend2, lag(5); 
newey wage trend1 trend2, lag(5)  force;

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1949;
replace trend1=0 if year>1948;

newey mec trend1 trend2, lag(5); 
newey wage trend1 trend2, lag(5) force;

/* Ireland Wages */

use "irelandwagesrep.dta", clear;

tsset year;

gen trend1=year-1900;
gen trend2=year-1900;
replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1931;
replace trend1=0 if year>1930;

newey ratio trend1 trend2 , lag(5); 

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1936;
replace trend1=0 if year>1935;

newey ratio trend1 trend2  , lag(5); 

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1941;
replace trend1=0 if year>1940;

newey ratio trend1 trend2 , lag(5); 

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1946;
replace trend1=0 if year>1945;

newey ratio trend1 trend2 , lag(5);

test trend1=trend2;
replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1951;
replace trend1=0 if year>1950;

newey ratio trend1 trend2, lag(5);

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1956;
replace trend1=0 if year>1955;

newey ratio trend1 trend2 , lag(5);

replace trend1=year-1900;
replace trend2=year-1900;
replace trend2=0 if year<1961;
replace trend1=0 if year>1960;

newey ratio trend1 trend2  , lag(5);

clear;

/**********************
Descriptive Statistics of Data for Main Analyses (Appendix Table 3)
**********************/

misum iqimpr wcentld wdeccentld fempart mgdppc leftgov nondem secsharel10 top1la top10la top10la_top1la
tradedep totden2 funisuf wagctl2 if 
(period>3 & stnum~=205) | (period>5 & stnum==205), nsets(10);

log close;


